﻿/* ---------------------------------------------------------------------------
   © 2016 HID Global Corporation/ASSA ABLOY AB.  All rights reserved.

   Redistribution and use in source and binary forms, with or without modification,
   are permitted provided that the following conditions are met:
      - Redistributions of source code must retain the above copyright notice,
        this list of conditions and the following disclaimer.
      - Redistributions in binary form must reproduce the above copyright notice,
        this list of conditions and the following disclaimer in the documentation
        and/or other materials provided with the distribution.
        THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
        AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
        THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
        ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
        FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
        (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
        LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
        ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
        (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
        THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
--------------------------------------------------------------------------- */

//
// MainPage.xaml.cpp
// Implementation of the MainPage class.
//

#include "pch.h"
#include "MainPage.xaml.h"

using namespace mscrypto_cppUWPsample;
using namespace Concurrency;
using namespace Platform;
using namespace Windows::Foundation;
using namespace Windows::Security::Cryptography;
using namespace Windows::Security::Cryptography::Certificates;
using namespace Windows::Security::Cryptography::Core;
using namespace Windows::Storage::Streams;
using namespace Windows::UI::ViewManagement;

MainPage::MainPage()
{
	static Size WindowSize = Size(545, 650);
	InitializeComponent();
	ApplicationView::PreferredLaunchViewSize = WindowSize;
	ApplicationView::PreferredLaunchWindowingMode = ApplicationViewWindowingMode::PreferredLaunchViewSize;

	CertificateList->Visibility = Windows::UI::Xaml::Visibility::Collapsed;
	BtShowCertificatesList->Visibility = Windows::UI::Xaml::Visibility::Visible;
	UserAction1->Visibility = Windows::UI::Xaml::Visibility::Visible;
	BtSignData->Visibility = Windows::UI::Xaml::Visibility::Collapsed;
	UserAction2->Visibility = Windows::UI::Xaml::Visibility::Collapsed;
	BtRestartSample->Visibility = Windows::UI::Xaml::Visibility::Collapsed;
}

void MainPage::ShowCertificatesList()
{
	CertificateList->Items->Clear();

	create_task(CertificateStores::FindAllAsync()).then([this](Windows::Foundation::Collections::IVectorView<Windows::Security::Cryptography::Certificates::Certificate ^> ^ CertListTmp)
	{
		certList = CertListTmp;
		CertificateList->Items->Clear();

		for (uint32 i = 0; i < certList->Size; i++)
		{
			Certificate^ cert = certList->GetAt(i);
			CertificateList->Items->Append(cert->FriendlyName);
		}

		if (CertificateList->Items->Size == 0)
		{
			BtSignData->IsEnabled = false;
			OutputText->Text += "No certificates found in your personal certificate store.\n";
			CertificateList->Visibility = Windows::UI::Xaml::Visibility::Collapsed;
		}
		else
		{
			OutputText->Text += CertificateList->Items->Size + " certificate(s) found in your personal certificate store.";
			CertificateList->Visibility = Windows::UI::Xaml::Visibility::Visible;
			BtSignData->IsEnabled = true;
			BtShowCertificatesList->Visibility = Windows::UI::Xaml::Visibility::Collapsed;
			UserAction1->Visibility = Windows::UI::Xaml::Visibility::Collapsed;
			UserAction2->Visibility = Windows::UI::Xaml::Visibility::Visible;
			BtSignData->Visibility = Windows::UI::Xaml::Visibility::Visible;
			CertificateList->IsEnabled = true;
			CertificateList->SelectedIndex = 0;
		}

		BtRestartSample->Visibility = Windows::UI::Xaml::Visibility::Collapsed;

	});
}

void MainPage::SignAndVerifySignature(Platform::Object^ sender, Windows::UI::Xaml::RoutedEventArgs^ e)
{
	Certificate^ selectedCertificate = nullptr;
	BtSignData->IsEnabled = false;
	CertificateList->IsEnabled = false;

	//get the selected certificate
	if (CertificateList->SelectedIndex >= 0 && safe_cast<unsigned int>(CertificateList->SelectedIndex) < certList->Size)
	{
		selectedCertificate = certList->GetAt(CertificateList->SelectedIndex);
	}

	if (selectedCertificate == nullptr)
	{
		OutputText->Text += "\nPlease select a certificate first.";
		return;
	}
	else
	{
		OutputText->Text += "\nTrying to sign some datas with the following certificate: " + selectedCertificate->FriendlyName;
	}

	// retrieve selected certificate private key
	create_task(PersistedKeyProvider::OpenKeyPairFromCertificateAsync(selectedCertificate, HashAlgorithmNames::Sha1, CryptographicPadding::RsaPkcs1V15))
		.then([this](task<CryptographicKey^> getKeyPair)
	{
		try
		{
			CryptographicKey^ privateKey = nullptr;
			privateKey = getKeyPair.get();

			String^ myData = "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.";
			IBuffer^ myDataToSign = CryptographicBuffer::ConvertStringToBinary(myData, BinaryStringEncoding::Utf16BE);

			// sign some data with this key
			create_task(CryptographicEngine::SignAsync(privateKey, myDataToSign)).then([this, privateKey, myDataToSign](task<IBuffer^> GetSigned)
			{
				IBuffer^ signedData;

				try
				{
					signedData = GetSigned.get();
					OutputText->Text += "\nData digital signature succeed.";

					try
					{
						bool bresult = CryptographicEngine::VerifySignature(privateKey, myDataToSign, signedData);
						if (bresult == true)
						{
							OutputText->Text += "\nDigital signature verification succeed.";
						}
						else
						{
							OutputText->Text += "\nDigital signature verification failed!";
						}
					}
					catch (Exception^ ex)
					{
						OutputText->Text += "\nDigital signature verification failed with the following error:\n" + ex->Message;
					}
				}
				catch (Exception^ ex)
				{
					OutputText->Text += "\nData digital signature failed with the following error:\n" + ex->Message;
				}

				BtRestartSample->Visibility = Windows::UI::Xaml::Visibility::Visible;
				CertificateList->Visibility = Windows::UI::Xaml::Visibility::Collapsed;
				UserAction1->Visibility = Windows::UI::Xaml::Visibility::Collapsed;
				BtSignData->Visibility = Windows::UI::Xaml::Visibility::Collapsed;
				UserAction2->Visibility = Windows::UI::Xaml::Visibility::Collapsed;
			});
		}
		catch (Exception^ ex)
		{
			OutputText->Text += "\nCertificate key pair retrieval failed with the following error:\n" + ex->Message;

			BtRestartSample->Visibility = Windows::UI::Xaml::Visibility::Visible;
			CertificateList->Visibility = Windows::UI::Xaml::Visibility::Collapsed;
			UserAction1->Visibility = Windows::UI::Xaml::Visibility::Collapsed;
			BtSignData->Visibility = Windows::UI::Xaml::Visibility::Collapsed;
			UserAction2->Visibility = Windows::UI::Xaml::Visibility::Collapsed;
		}
	});
}

void MainPage::RestartSample(Platform::Object^ sender, Windows::UI::Xaml::RoutedEventArgs^ e)
{
	CertificateList->Visibility = Windows::UI::Xaml::Visibility::Collapsed;
	BtShowCertificatesList->Visibility = Windows::UI::Xaml::Visibility::Visible;
	UserAction1->Visibility = Windows::UI::Xaml::Visibility::Visible;
	BtSignData->Visibility = Windows::UI::Xaml::Visibility::Collapsed;
	UserAction2->Visibility = Windows::UI::Xaml::Visibility::Collapsed;
	BtRestartSample->Visibility = Windows::UI::Xaml::Visibility::Collapsed;
	OutputText->Text = "";
}


